#!/usr/bin/perl
# UserLog.pl Display the user activity data log table UserLog.html from TalkSelect.html and UserTable.html
# See Config.ini for instructions
# Author: David best
# Website: https://www.bestaccessibility.consulting
##############################################################################

use warnings;
use File::Find;
use File::Path;
use Mail::Sendmail;
use CGI;
$query = new CGI;
use Cwd;
chdir('..');
print "Content-type: text/html\n\n";
#print Dump;

##############################################################################
# Set default values of variables
#
$modeCode = '';
$modeCode = $query->param('ModeCode');

my ($day, $month, $year) = (localtime(time))[3,4,5];
my ($second, $minute, $hour) = (localtime(time))[0,1,2];
if ( $hour < 10 ) { $hour = "0$hour"; }
if ( $minute < 10 ) { $minute = "0$minute"; }
if ( $second < 10 ) { $second = "0$second"; }
if ( $day < 10 ) { $day = "0$day"; }
$month++;
if ( $month < 10 ) { $month = "0$month"; }
$year += 1900;
$cdate = "$year-$month-$day";
$ctime = "$hour:$minute:$second";

$homeDir = 'https://edu.davidbest.ca';
$talkDir = 'Talk';
$talkAV = "$homeDir\/$talkDir\/AV";
$talkimg = "$homeDir\/$talkDir\/img";
$talkjs = "$homeDir\/$talkDir\/js";
$talkCSS = "$homeDir\/$talkDir\/CSS";
$CSSfiles = 'style1.css';
$CSSUserFiles = 'style1.css';
$styleLink = "$talkCSS\/style1.css";
$Config = 'Config.ini';
$userLog = 'UserLog.html';
$tmpFile = 'tmp.html';
$author = 'info@David.Best';
$authorUrl = 'mailto:info@david.best';
$logoLink = 'https://www.bestaccessibility.consulting';
$logoFile = 'eagle-150x150.jpg';
$logoAlt = 'BEST Logo';

$ext = '.html';
$doctype = '<!DOCTYPE html>';
$charset = 'UTF-8';
$baselang = 'en-CA';
$langattr = " dir=\"ltr\" lang=\"$baselang\"";
$metaCharset = "<meta http-equiv=\"Content-type\" content=\"text/html\" charset=\"$charset\">\n";
$viewport = "<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n";
$newWindow = "<a target=_blank title=\"Opens in a new window\" href=";
#
# end of default values
##############################################################################

##############################################################################
# reading Talk parameters input from config.ini
#print STDOUT "\n--- Reading parameters file $Config ---\n";
if (open(CFG, $Config))
{
  local(@file,$counter);
  $counter = 0;
  @file = <CFG>;
  @PARAM = ();
  do
  {
    if ($file[0] =~ /^[^#\n\r]/)
    {
      $file[0] =~ s/\n//;    # remove UNIX \n 
      $file[0] =~ s/\r//;    # remove WINDOWS \r    
      $file[0] =~ s/ *= */=/;
      $PARAM[$counter++] = $file[0];
    }
  } while (shift(@file));
}
#
# process parameters
# Each preset variable is now re-attributed using the user preferences
foreach (@PARAM)
{
  @_ = split(/ *= */);
  $cmd="\$$_[0] = \'$_[1]\';";
  if (length $_[1] != 0)
  {
    eval($cmd);
  }
}
#
# save the style sheet file locations into tables 
@CSSlist = split(',',$CSSfiles);
$nbCSSlist = $#CSSlist + 1;
@CSSuser = split(',',$CSSUserFiles);
$nbCSSuser = $#CSSuser + 1;
#
# Save the author variables
if ($authorUrl)
{
  $author = "<a href=\"$authorUrl\">$author</a>";
}
if ($author2 && $author2Url)
{
  $author2 = "<a href=\"$author2Url\">$author2</a>";
}
if ($author2)
{
  $author = $author." &amp; ".$author2;
}
#
# End of reading config.ini file parameters
##############################################################################

##############################################################################
# Read User Log table
#print "\n--- Read user log file $userLog ---\n";
my $sep = $/;
$/ = undef;
if (open(USR, "<$userLog"))
{
  $log = <USR>;
  $result = close(USR);
  $tag = "</tr>";
  @table = split(/$tag/i, $log);
  $RowTotal = $#table + 1; # compute the total number of rows
  $logTable = "<table role=table cols=7>";
  $logTable .= "<tr role=row><th>User Counter</th><th>Access Date/Time ET</th><th>User Name</th><th>User Email</th><th>Talk Topic</th><th>User Comment</th><th>User Suggestion</th></tr>";
  $logTable .= "$log";
  $logTable .= "<\/table>";
  $styleLink = "<link href=\"$talkCSS\/$CSSlist[0]\" rel=\"stylesheet\" type=\"text/css\" title=\"User Activity Data Log\">";
#
# Display the User Log
    open(USR, ">$tmpFile");
    print USR <<END;
$doctype
<html$langattr>
<head>
<meta http-equiv="Content-type" content="text/html" charset="$charset">
<meta name="viewport" content="width=device-width, initial-scale=1.0" >
<title>User Activity Data Log</title>
$styleLink
</head>
<body><main>
<div id="container">
  <h1>User Activity Data Log</h1>
  <p>Total number of users = $RowTotal</p>
  $logTable
</div>
<p><button onClick="history.go(-1);return true;">Back to previous page</button></p>
</main></body>
</html>
END
  $result = close(USR);
}
$/ = $sep;
#print STDOUT "\n--- End of processing ---\n";
open(USR, "<$tmpFile");
print STDOUT <USR>;
exit;
# &EmailNotice(); # Send email notification
#
# the User Log has been read and displayed
##############################################################################

#############################################################################
## Send email notice (currently not available)
#
sub EmailNotice
{
  my $to = $author;
  my $from = 'info@davidbest.ca';
  my $subject = 'Notice of access to BEST Education website.';
  my $message = "Accessibility training $TalkTopic has been accessed.\n";
  my $message .= "$Name: $UserName<br>\n";
  my $message .= "Email: $UserEmail<br>\n";
  my $message .= "Date: $cdate / $ctime</p>\n";
#  open(MAIL, "|/usr/sbin/Sendmail -t");
#  print MAIL 'MIME-Version: 1.0';
#  print MAIL 'Content-Type: text/html; charset="us-ascii"';
#  print MAIL 'Content-Transfer-Encoding: 7bit';
#  print MAIL "To: $to\n";
#  print MAIL "From: $from\n";
#  print MAIL "Subject: $subject\n\n";
#  print MAIL $message;
#  $result = close(MAIL);
#  if ($result)
#  {
#   print "Email Sent. Result = $result\n";
#  }
#  else
#  {
#    print "There was a problem. Result=$result er1=$! er2=$? \n";
#    exit 0;
#  }
}
#
# The email notice has been sent
##############################################################################
