#!/usr/bin/perl
# talkselect.pl Select presentation Talk Slide show (created by TalkCreate.pl).
# See Config.ini for instructions
# Author: David best
# Website: https://www.bestaccessibility.consulting
##############################################################################

use warnings;
use File::Find;
use File::Path;
use Mail::Sendmail;
use CGI;
$query = new CGI;
use Cwd;
chdir('..');
print "Content-type: text/html\n\n";
#print Dump;

&DefaultParameters;
&DefaultConfig;
&AccessTalk;
exit;

##############################################################################
# Default parameters
sub DefaultParameters
{
#print STDOUT "\n--- Set default parameters ---\n";
  my ($day, $month, $year) = (localtime(time))[3,4,5];
  my ($second, $minute, $hour) = (localtime(time))[0,1,2];
  if ( $hour < 10 ) { $hour = "0$hour"; }
  if ( $minute < 10 ) { $minute = "0$minute"; }
  if ( $second < 10 ) { $second = "0$second"; }
  if ( $day < 10 ) { $day = "0$day"; }
  $month++;
  if ( $month < 10 ) { $month = "0$month"; }
  $year += 1900;
  $cdate        = "$year-$month-$day";
  $ctime        = "$hour:$minute:$second";

  $modeCode = '';
  $modeCode = $query->param('ModeCode');
  $talkTopic = $query->param('TalkTopic');

  $ext = '.html';
  $homeDir = 'https://edu.davidbest.ca';
  $talkDir = 'Talk';
  $talkAV = "$homeDir\/$talkDir\/AV";
  $talkdoc = "$homeDir\/$talkDir\/doc";
  $talkimg = "$homeDir\/$talkDir\/img";
  $talkjs = "$homeDir\/$talkDir\/js";
  $talkCSS = "$homeDir\/$talkDir\/CSS";
  $CSSfiles = 'style1.css,style2.css';
  $CSSUserFiles = 'style1.css,style2.css';
  $styleLink = "$talkCSS\/style1.css";
  $Config = 'Config.ini';
  $tmpfile = 'tmp.html';
  $talkTOC = 'Overview';
  $talkSlide = "$talkTOC$ext";
  $author = 'info@David.Best';
  $authorUrl = 'mailto:info@david.best';

  $doctype = '<!DOCTYPE html>';
  $charset = 'UTF-8';
  $baselang = 'en-CA';
  $langattr = " dir=\"ltr\" lang=\"$baselang\"";
  $metaCharset = "<meta http-equiv=\"Content-type\" content=\"text/html\" charset=\"$charset\">\n";
  $viewport = "<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n";
  $newWindow = "<a target=_blank title=\"Opens in a new window\" href=";
}
# End of default values for the slide show
##############################################################################

##############################################################################
# Reading Talk parameters input from config.ini
sub DefaultConfig
{
#print STDOUT "\n--- Reading parameters file $Config ---\n";
  if (open(CFG, $Config))
  {
    local(@file,$counter);
    $counter = 0;
    @file = <CFG>;
    @PARAM = ();
    do
    {
      if ($file[0] =~ /^[^#\n\r]/)
      {
        $file[0] =~ s/\n//;    # remove UNIX \n 
        $file[0] =~ s/\r//;    # remove WINDOWS \r    
        $file[0] =~ s/ *= */=/;
        $PARAM[$counter++] = $file[0];
      }
    } while (shift(@file));
#
# process parameters
# Each preset variable is now re-attributed using the user preferences
    foreach (@PARAM)
    {
      @_ = split(/ *= */);
      $cmd="\$$_[0] = \'$_[1]\';";
      if (length $_[1] != 0)
      {
        eval($cmd);
      }
    }
#
# save the style sheet file locations into tables 
    @CSSlist = split(',',$CSSfiles);
    $nbCSSlist = $#CSSlist + 1;
    @CSSuser = split(',',$CSSUserFiles);
    $nbCSSuser = $#CSSuser + 1;
    $styleLink = "$talkCSS\/$CSSlist[0]";
#
# Save the author variables
    if ($authorUrl)
    {
      $author = "<a href=\"$authorUrl\">$author</a>";
    }
    if ($author2 && $author2Url)
    {
      $author2 = "<a href=\"$author2Url\">$author2</a>";
    }
    if ($author2)
    {
      $author = $author." &amp; ".$author2;
    }
  }
}
# End of reading $config file parameters
##############################################################################

##############################################################################
# Access requested talk slide show
sub AccessTalk
{
#print STDOUT "\n--- Accessing $talkTopic presentation ---\n";
  chdir("$talkTopic");
  if (!open(TLK, "<$talkSlide"))
  {
    $found = 0;
    print STDOUT <<END;
$doctype
<html$langattr>
<head>
<meta http-equiv='refresh' content='30;URL=$homeDir/$talkDir/TalkSelect.html'>
<meta name="viewport" content="width=device-width, initial-scale=1.0" >
<title>$talkTopic</title>
<link href="$styleLink" rel="stylesheet" type="text/css" title="Talk">
</head>
<body>
<main class="maincontent">
<h1 id="main" class="alignCenter">$talkTopic is currently not available.</h1>
<p>Redirecting back to the Talk Selection page in 30 seconds.<br>
<a href="$homeDir/$talkDir/TalkSelect.html">Close</a></p>
</main>
</body>
</html>
END
    exit;
  }
#
# Display the talk slide show
  $Talk = <TLK>;
  $found = 1;
  $slideShow = "$homeDir\/$talkDir\/$talkTopic\/$talkSlide";
  print "<meta http-equiv='refresh' content='0;URL=$slideShow'>\n";
}
# End of slide show access
##############################################################################
