#!/usr/bin/perl
# TalkCreate.pl Create Talk Topic Slide Show presentation
# split the Talk File into slides, subpage slides and Tabpanels
# See Config.ini for instructions
# Author: David best
# Website: https://www.bestaccessibility.consulting
##############################################################################

##############################################################################
# Set default values of variables.
use warnings;
use File::Find;
use File::Path;
use Mail::Sendmail;
use CGI;
$query = new CGI;
use Cwd;
chdir('..');

$modeCode = '';
$modeCode = $query->param('ModeCode');
$talkTopic = $query->param('TalkTopic');

my ($day, $month, $year) = (localtime(time))[3,4,5];
my ($second, $minute, $hour) = (localtime(time))[0,1,2];
if ( $hour < 10 ) { $hour = "0$hour"; }
if ( $minute < 10 ) { $minute = "0$minute"; }
if ( $second < 10 ) { $second = "0$second"; }
if ( $day < 10 ) { $day = "0$day"; }
$month++;
if ( $month < 10 ) { $month = "0$month"; }
$year += 1900;
$cdate = "$year-$month-$day";
$ctime = "$hour:$minute:$second";

$doctype = '<!DOCTYPE html>';
$charset = 'UTF-8';
$baselang = 'en-CA';
$langattr = " dir=\"ltr\" lang=\"$baselang\"";
$metaCharset = "<meta http-equiv=\"Content-type\" content=\"text/html\" charset=\"$charset\">\n";
$viewPort = "<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n";
$newWindow = "\<a target=_blank title=\"Opens in a new window\" href=\"";

$ext = ".html";
$homeDir = 'https://edu.davidbest.ca';
$talkDir = 'Talk';
$talkAV = "$homeDir\/$talkDir\/AV";
$talkdoc = "$homeDir\/$talkDir\/doc";
$talkimg = "$homeDir\/$talkDir\/img";
$talkjs = "$homeDir\/$talkDir\/js";
$talkCSS = "$homeDir\/$talkDir\/CSS";
$CSSfiles = 'style1.css,style2.css,style3.css';
$CSSUserFiles = 'style1.css,style2.css,style3.css';
$styleFile = "$talkCSS\/style1.css";
$talkTOC = 'Overview';
$Config = 'Config.ini';
$talkEnd = 'Trailer.html';
$author = 'info@David.Best';
$authorUrl = 'mailto:info@david.best';
$logoLink = 'https://www.bestaccessibility.consulting';
$logoFile = 'eagle-150x150.jpg';
$logoAlt = 'BEST Logo';
$logoLink2 = ''; # link to a potential second reference
$logoFile2 = ''; # location of a second logo
$logoAlt2 = ''; # alternate representation of the second logo

$talkFile = "$talkTopic$ext";
$orgName = 'Business and Educational Services in Technology (BEST)';
$startResource = "resource";
$endResource = "\/resource";
$startPage = "section";
$endPage = "\/section";
$startTab = "article";
$endTab = "\/article";
$startList = "dl";
$endList = "\/dl";
$trailer = '';
$left = 'left.png';
$right = 'right.png';
$tocimg = 'toc.png';
$change = 'change.png';
$prevKey = 'P';	# accesskey for previous slide
$nextKey = 'N';	# accesskey for next slide
$tocKey = 'C';	# accesskey for table of contents
$styleKey = 'S';	# accesskey for changing style sheets
print "Content-type: text/html\n\n";
#print Dump;
#
# end of default values for the presentation
##############################################################################

##############################################################################
# reading Talk parameters input from config.ini
#print STDOUT "\n--- Reading parameters file $Config ---\n";
if (open(CFG, $Config))
{
  local(@file,$counter);
  $counter = 0;
  @file = <CFG>;
  @PARAM = ();
  do
  {
    if ($file[0] =~ /^[^#\n\r]/)
    {
      $file[0] =~ s/\n//;    # remove UNIX \n 
      $file[0] =~ s/\r//;    # remove WINDOWS \r    
      $file[0] =~ s/ *= */=/;
      $PARAM[$counter++] = $file[0];
    }
  } while (shift(@file));
}
#
# process parameters
# Each preset variable is now re-attributed using the user preferences
foreach (@PARAM)
{
  @_ = split(/ *= */);
  $cmd="\$$_[0] = \'$_[1]\';";
  if (length $_[1] != 0)
  {
    eval($cmd);
  }
}
#
# save the style sheet file locations into tables 
@CSSlist = split(',',$CSSfiles);
$nbCSSlist = $#CSSlist + 1;
@CSSuser = split(',',$CSSUserFiles);
$nbCSSuser = $#CSSuser + 1;
#
# Save the author variables
if ($authorUrl)
{
  $author = "<a href=\"$authorUrl\">$author</a>";
}
if ($author2 && $author2Url)
{
  $author2 = "<a href=\"$author2Url\">$author2</a>";
}
if ($author2)
{
  $author = $author." &amp; ".$author2;
}
#
# End of reading config.ini file parameters
##############################################################################

##############################################################################
# read the raw HTML presentation
#
#print STDOUT "\n--- Process the Talk HTML file $talkFile ---\n";
my $sep = $/;
$/ = undef;
if (!open(TLK, "$talkFile"))
{
  print STDOUT <<END;
$doctype
<html$langattr>
<head>
<meta http-equiv='refresh' content='30;URL=$homeDir/$talkDir/TalkCreate.html'>
<meta name="viewport" content="width=device-width, initial-scale=1.0" >
<title>Talk Create | $talkTopic</title>
<link href=\"$talkCSS\/$CSSlist[0]\" rel=\"stylesheet\" type=\"text/css\" title=\"Talk\">
</head>
<body>
<main class="maincontent">
<h1 id="main" class="alignCenter">Slide Show presentation Content Not Available</h1>
<p>Slide show presentation content <q>$talkTopic</q> is currently not available.</p>
<p>Redirecting to the author Talk Create learning topic page in 30 seconds.<br>
<a href="$homeDir/$talkDir/TalkCreate.html">Close</a></p>
</main>
</body>
</html>
END
  exit;
}
#
my $buf = <TLK>;
close(TLK);
$buf =~ s/<!--.*?-->//sgo;  # Remove comments from the raw presentation
$/ = $sep;
#
# the slidemaker tool assumes that each slide is self contained between  2 sets of h1 elements
# split using <h1...> and </h1> as separator (ignores attributes!)
@table = split(/<\/?[hH]1[^>]*>/, $buf);
#
# First table entry is the Talk Title
shift(@table);
$talkTitle = "$table[0]";
shift(@table);
$talkIntro = "$table[0]";
#
# Compute the total number of slides
$total = $#table / 2;
if ($#table % 2 != 0)
{
	 $total = ($#table +1)/2;
}
#
# raw presentation has been read successfully
##############################################################################

#############################################################################
# processing the slides
#
#print STDOUT "\n--- Processing $total slides ---\n";
&openOverview;
#
# Start the slide count so we can number them
# @table is the array containing each slide with its title for each slide to be generated
# we delete each slide and its title when generated so that the current slide and its title are always at $table[0] (for the title) and $table[1] (for the slide content)
$slideCount = 1;
do
{
# Get rid of the first element contained by the raw presentation array then $table[0] is the title of the slide to be generated
  shift(@table);
  $table[0] =~ s/\n+/ /g;  # replace return character by a white space
  $table[0] =~ s/ +/ /g;  # concatenate several white spaces to only one
  $table[0] =~ s/^ //;  # remove all the starting white spaces in the title
  $table[0] =~ s/ $//;  # remove all trailing white spaces in the title
  $slideTitle = $table[0];
# Need to check if the title contains any anchor. if so it needs to be removed because the title is being used in the table of content to link to the corresponding slide
  $table[0] =~ s/(.*)<a[^>]*>(.*)<\/a>(.*)/$1$2$3/;
# Grab next slide title $table[2] (if there's a next slide) to be able to use in the 'next' navigation button
  $next_slide_title = $table[2] if $table[2];
# Remove any anchor from the next slide title
  $next_slide_title =~ s/(.*)<a[^>]*>(.*)<\/a>(.*)/$1$2$3/;
# Add the title of the current slide to the table of content
  &addTitle("$table[0]",$slideCount);
#
# The current slide content is stored $table[1]. there is an attempt to make sure it's clean HTML
#  $slideInfo = &clean_html($table[1]);  # Remove hidden comments
  $slideInfo = $table[1];  # Do not remove hidden comment;
#
# Generate the current slide
# Parameters are: title of the slide, its content, the slide number, the title of the previous slide and the title of the next slide
  &createSlide("$slideTitle",$slideInfo,$slideCount++,$previous_slide_title,$next_slide_title);
# Save the title of the previous slide to be displayed in the 'previous' navigation button
  $previous_slide_title="$table[0]";
}
#
# Process the next slide 
while (shift(@table));
&closeOverview;  # Close the table of content
#
# Generate more toc with the all the style sheets
&generateTOC;
#
# Redirect to the TalkSelect.html slide show
#print STDOUT "\n--- Finished ---\n";
#print "<meta http-equiv='refresh' content='0;URL=$overview$ext'>\n";
print STDOUT <<END;
$doctype
<html$langattr>
<head>
<meta http-equiv='refresh' content='30;URL=../TalkSelect.html'>
<meta name="viewport" content="width=device-width, initial-scale=1.0" >
<title>Talk Create | $talkTitle</title>
<link href="$talkCSS/$CSSlist[0]" rel="stylesheet" type="text/css" title="Talk">
</head>
<body>
<main class="maincontent">
<h1 id="main" class="alignCenter">Slide Show Content Complete</h1>
<p>Slide show content <q>$talkTitle</q> has been created.<br>
$talkIntro</p>
<p>Redirecting to the user Talk Select learning topic page in 30 seconds.<br>
<a href="../TalkSelect.html">Close</a></p>
</main>
</body>
</html>
END
exit;
#
# End of the slidemaker main program
##############################################################################

##############################################################################
#
sub openOverview 
{
# Generate the header table of content of the presentation
# Create the Talk sub folder
#print STDOUT "\n--- mkdir=$talkTopic ---\n";
  find(\&Create_Talk, "$talkTopic");
  rmdir($talkTopic);
  mkdir($talkTopic, 0777);
  chdir($talkTopic);
#
  sub Create_Talk
  {
    my $file = $_;
    my $dir = $File::Find::dir;
    my $path = $File::Find::name;
#print STDOUT "\n--- CreateTalk (file,dir,path): $file $dir $path ---\n";
#   print $file if -d $file;
    rmdir($file) if -d $file;
#   print $file if -f $file;
    unlink($file) if -f $file;
  }
#
# Open the table of content file to write to
$overview = "$talkTOC";
#print STDOUT "\n--- Open the table of content file $overview$ext to write to ---\n";
open(LST, ">$overview$ext");
#
# Here is the standard style sheet
$styleLink = "";
$styleLink = "<link href=\"$talkCSS\/$CSSlist[$0]\" rel=\"stylesheet\" type=\"text/css\" title=\"Talk-CSS\">";
# Overload with the user css if it exists
if ($CSSuser[$0])
{
  $styleLink = "\n<link href=\"$talkCSS\/$CSSuser[$0]\" rel=\"stylesheet\" type=\"text/css\" title=\"Talk-CSS\">";
}
local($lastslide);
$lastslide = $nbCSSlist-1;
print LST <<END;
$doctype
<html$langattr>
<head>
<meta http-equiv="Content-type" content="text/html" charset="$charset">
<meta name="viewport" content="width=device-width, initial-scale=1.0" >
<title>Table Of Contents | $talkTitle</title>
<link rel="next" href="slide1-0$ext" title="Next">
<link rel="first" href="slide1-0$ext" title="First">
<link rel="last" href="slide$lastslide-0$ext" title="Last">
$styleLink
<script type="text/javascript" src="$talkjs/jquery-1.11.0.min.js"></script>
<script type="text/javascript" src="$talkjs/detailsGroup.js"></script>
<script type="text/javascript" src="$talkjs/AutoTab.js"></script>
<script type="text/javascript" src="$talkjs/CommentToggle.js"></script>
<script type="text/javascript" src="$talkjs/utils.js"></script>
</head>
<body>
END
#
# If there's only one logo to put on the toc
if (length $logoFile2 == 0)
{
  print LST <<END;
<header id="BannerImg"><a href="$logoLink"><img src="$talkimg\/$logoFile" class="alignCenter" alt="$logoAlt"></a></header>
END
} else
{
# the user chose a second logo
  print LST <<END;
<header id="BannerImg"><a href="$logoLink"><img src="$talkimg\/$logoFile" class="alignCenter" alt="$logoAlt"></a>&#160;
<a href="$logoLink2"><img src="$talkimg\/$logoFile2" class="alignCenter" alt="$logoAlt2"></a></header>
END
}
print LST <<END;
<main class="maincontent">
<h1 id="main" class="alignCenter">$talkTitle</h1>
$talkIntro
<nav class="navtoc">
<h2 class="alignCenter">Table Of Contents</h2>
<ol>
END
}
#
# The beginning of the table of content has been generated and saved
##############################################################################

##############################################################################
# Generate the footer of the table of content
#
sub closeOverview
{
#print STDOUT "\n--- Close overview subroutine ---\n";
  print LST <<END;
</ol>
</nav>
</main>
<footer role=region class="footercontent" aria-label="Footer">
<p class="author">$author</P>
<p class="author"><a href="$homeDir\/$talkDir\/TalkSelect.html" title="Return To Home Page">$orgName</a></p>
</footer>
</body>
</html>
END
  close(LST); 
}
#
# The toc has been completed and saved
##############################################################################

##############################################################################
# Add an item in the toc
#
sub addTitle 
{
#print STDOUT "\n--- addTitle subroutine ---\n";
  $_[0] =~ s/\r//ig;  # remove the windows CR+LF 
  $_[0] =~ s/<[^>]+>//g;
  if (length $_[0] == 0)
  { return 1; }
# Add accesskey for first 9 slides (1-9), and tabindex for all slides
    if ($_[1] < 10)
    {
      print LST <<END;
<li><a accesskey="$_[1]" tabindex="$_[1]" href=\"slide$_[1]-0$ext#main">$_[0]</a></li>
END
    } else
    {
      print LST <<END;
<li><a tabindex="$_[1]" href=\"slide$_[1]-0$ext#main">$_[0]</a></li>
END
    }
}
#
# End of Add Title subroutine
##############################################################################

##############################################################################
# Generate the current slide
#
sub createSlide
{
# Parameters are: the slide title, its content, its number, the next slide title and the previous slide title
#print STDOUT "\n--- Create slide subroutine ---\n";
  if (length $_[0] == 0)
  { return 1; }
# Work the slide title, the previous and next titles
  $_[0] =~ s/\r//ig;  # remove the windows CR+LF 
  $_[3] =~ s/\r//ig; 
  $_[4] =~ s/\r//ig;
  $title = $_[0];
# Remove any tags from the prev & next titles
  $_[3] =~ s/<[^>]+>//g;
  $_[4] =~ s/<[^>]+>//g;
  $title =~ s/<[^>]+>//g;
# Replace double quotes
#  $_[0] =~ s/"/&#34;/g;
  $_[3] =~ s/"/&#34;/g;
  $_[4] =~ s/"/&#34;/g;
# Work the slide content
  $_[1] =~ s/<\/body>//i;  # remove if any
  $_[1] =~ s/<\/html>//i;  # remove if any
  $status = sprintf "Slide %2d: %s\n", $_[2], $_[0];
  $status =~ s#<[^>]+>##g;
  &verify_html($_[1]);  # check the <img> for alt text
#
# We create as many slides as there are css files
  my $cNumber = 0;
  for ($i=0;$i<$nbCSSlist;$i++)
  {
    $contentLength = length($slideInfo);
    @contentTable = split("\n", $slideInfo);
    $ttl = $#contentTable+1;
    $cNumber = $i+1;
    $cNumber = 0  if ($i == $nbCSSlist-1);
    $slideName = "slide$_[2]-$i$ext";
# Prepare slide content links
    local($navHead);
    local($navFoot);
    local($toclink);
    local($firstlink);
    local($lastlink);
    local($prevlink);
    local($nextlink);
# Navigation bar with images to previous slide, toc and next slide
    $navHead = "<div class=\"navbar\">\n";
    $navFoot = "<div class=\"navbar\">\n";
# The toc link needs to match the slide index so that the style sheets match between the slides and the toc
    $toclink = "<link rel=\"contents\" href=\"$overview$ext\" title=\"Contents\">\n".
    "<link rel=\"top\" href=\"$overview$ext\" title=\"Top\">";
    $firstlink = "<link rel=\"first\" href=\"slide1-$i$ext\" title=\"First\">";
    $lastlink = "<link rel=\"last\" href=\"slide".eval($nbCSSlist-1)."-$i$ext\" title=\"Last\">";
# Initialization of the navigation links
    $nextlink = "";
    $prevlink = "";
    if ($_[2]>1)
    {
      $prevlink = "<link rel=\"prev\" href=\"slide".eval($_[2]-1)."-$i$ext\" title=\"Previous\">";
      $navHead .= "<a aria-label=\"Previous\" rel=\"prev\" href=\"slide".eval($_[2]-1)."-$i$ext\" accesskey=\"$prevKey\"><img src=\"$talkimg\/$left\" width=\"32\" height=\"32\" alt=\"\" title=\"Back to &#34;$_[3]&#34;\"></a>";
      $navFoot .= "<a aria-label=\"Previous\" rel=\"prev\" href=\"slide".eval($_[2]-1)."-$i$ext\" accesskey=\"$prevKey\"><img src=\"$talkimg\/$left\" width=\"32\" height=\"32\" alt=\"\" title=\"Back to &#34;$_[3]&#34;\"></a>";
    } else
    {
# Add a link back to the toc for the first slide
      if ($i == 0)
      {
        $prevlink = "<link rel=\"prev\" href=\"$overview$ext\" title=\"Previous\">";
        $navHead .= "<a aria-label=\"Previous\" rel=\"prev\" href=\"$overview$ext\" accesskey=\"$prevKey\"><img src=\"$talkimg\/$left\" width=\"32\" height=\"32\" alt=\"\" title=\"Back to &#34;$_[3]&#34;\"></a>";
        $navFoot .= "<a aria-label=\"Previous\" rel=\"prev\" href=\"$overview$ext\" accesskey=\"$prevKey\"><img src=\"$talkimg\/$left\" width=\"32\" height=\"32\" alt=\"\" title=\"Back to &#34;$_[3]&#34;\"></a>";
      } else
      {
        $prevlink = "<link rel=\"prev\" href=\"$overview$i$ext\" title=\"Previous\">";
        $navHead .= "<a aria-label=\"Previous\" rel=\"prev\" href=\"$overview-$i$ext\" accesskey=\"$prevKey\"><img src=\"$talkimg\/$left\" width=\"32\" height=\"32\" alt=\"\" title=\"Back to &#34;$_[3]&#34;\"></a>";
        $navFoot .= "<a aria-label=\"Previous\" rel=\"prev\" href=\"$overview-$i$ext\" accesskey=\"$prevKey\"><img src=\"$talkimg\/$left\" width=\"32\" height=\"32\" alt=\"\" title=\"Back to &#34;$_[3]&#34;\"></a>";
      }
    }
# Add Next link
    if ($_[2] != $total)
    {
      $nextlink = "<link rel=\"next\" href=\"slide".eval($_[2]+1)."-$i$ext\" title=\"Next\">";
      $navHead .= "<a aria-label=\"Next\" rel=\"next\" href=\"slide".eval($_[2]+1)."-$i$ext\" accesskey=\"$nextKey\"><img src=\"$talkimg\/$right\" width=\"32\" height=\"32\" alt=\"\" title=\"On to &#34;$_[4]&#34;\"></a>";
      $navFoot .= "<a aria-label=\"Next\" rel=\"next\" href=\"slide".eval($_[2]+1)."-$i$ext\" accesskey=\"$nextKey\"><img src=\"$talkimg\/$right\" width=\"32\" height=\"32\" alt=\"\" title=\"On to &#34;$_[4]&#34;\"></a>";
      $trailer = '';
    } else
    {
      $navHead .= "<img aria-label=\"No More Slides\" src=\"$talkimg\/$right\" width=\"32\" height=\"32\" alt=\"\" title=\"The end.\">";
#      $navFoot .= "<img aria-label=\"No More Slides\" src=\"$talkimg\/$right\" width=\"32\" height=\"32\" alt=\"\" title=\"The end.\">";
      $navFoot .= "<a aria-label=\"Exit\" rel=\"next\" href=\"$homeDir\/$talkDir\/TalkSelect.html\" accesskey=\"$nextKey\"><img src=\"$talkimg\/$right\" width=\"32\" height=\"32\" alt=\"\" title=\"Return To Home Page\"></a>";
# Read in the education trailer data file
      my $sep = $/;
      $/ = undef;
      if (open(EDU, "<..\/$talkEnd"))
      {
        $trailer = <EDU>;
        close(EDU);
        $trailer =~ s/\$talkTopic/$talkTopic/g;  # Replace with the actual topic name
      }
      $/ = $sep;
    }
# Add TOC link
    if ($i == 0)
    {
# We are using the first css file, so no need to number the toc
      $navHead = $navHead."<a aria-label=\"Contents\" rel=\"contents\" href=\"$overview$ext\" accesskey=\"$tocKey\"><img src=\"$talkimg\/$tocimg\" width=\"32\" height=\"32\" alt=\"\" title=\"Table of Contents\"></a>";
      $navFoot = $navFoot."<a aria-label=\"Contents\" rel=\"contents\" href=\"$overview$ext\" accesskey=\"$tocKey\"><img src=\"$talkimg\/$tocimg\" width=\"32\" height=\"32\" alt=\"\" title=\"Table of Contents\"></a>";
    } else
    {
# Change $toclink
      $toclink = "<link rel=\"contents\" href=\"$overview$i$ext\" title=\"Contents\">\n".
      "<link rel=\"top\" href=\"$overview$i$ext\" title=\"Top\">";
# We are using another css, the toc needs to match
      $navHead = $navHead."<a aria-label=\"Contents\" rel=\"contents\" href=\"$overview$i$ext\" accesskey=\"$tocKey\"><img src=\"$talkimg\/$tocimg\" width=\"32\" height=\"32\" alt=\"\" title=\"Table of Contents\"></a>";
      $navFoot = $navFoot."<a aria-label=\"Contents\" rel=\"contents\" href=\"$overview$i$ext\" accesskey=\"$tocKey\"><img src=\"$talkimg\/$tocimg\" width=\"32\" height=\"32\" alt=\"\" title=\"Table of Contents\"></a>";
    }
# Add Style change
    $navHead .= "<a aria-label=\"Change Style\" href=\"slide".eval($_[2])."-$cNumber$ext\" accesskey=\"$styleKey\"><img src=\"$talkimg\/$change\" width=\"32\" height=\"32\" alt=\"\" title=\"change style\"></a></div>";
    $navFoot .= "<a aria-label=\"Change Style\" href=\"slide".eval($_[2])."-$cNumber$ext\" accesskey=\"$styleKey\"><img src=\"$talkimg\/$change\" width=\"32\" height=\"32\" alt=\"\" title=\"change style\"></a></div>";
    $navHead .= "</div>";
    $navFoot .= "</div>";
# Here is the standard style sheet
    $styleLink = "";
    $styleFile = "$talkCSS\/$CSSlist[$i]";
    $styleLink = "<link href=\"$styleFile\" rel=\"stylesheet\" type=\"text/css\" title=\"Talk-CSS\">";
# We overload with the user css if it exists
    if ($CSSuser[$i])
    {
      $styleFile = "$talkCSS\/$CSSuser[$i]";
      $styleLink = "\n<link href=\"$styleFile\" rel=\"stylesheet\" type=\"text/css\" title=\"Talk-CSS\">";
    }
#
# Generate all the Resource content for the current slide
    $slideContent = '';
    $resourceContent = '';
    $found = 0;
    $resourceCount = 0;
    $tag = "$startResource";
    for ($k=0;$k<$ttl;$k++)
    {
      $resourceTmp = $contentTable[$k];
      $tagPos = index($resourceTmp, "<$tag");
      if ($found == 0)
      {
        if ($tagPos>-1)
        {
          $found = 1;
          $tag = "$endResource";
          $resourceCount++;
          $resourceContent .= "<div role=region class=\"comment\" aria-label=\"Resources\" style=\"display: none;\">\n";
          $resourceContent .= "<h2>Resources<\/h2>\n";
          $resourceContent .= "<ul>\n";
        } else
        {
          $resourceContent .= "$resourceTmp\n";
        }
      } else
      {
        if ($tagPos>-1)
        {
          $found = 0;
          $tag = "$startResource";
          $resourceContent .= "<\/ul>\n";
          $resourceContent .= "<\/div>\n";
        } else
        {
          $Pos = index($resourceTmp, "http");
          if ($Pos>-1)
          {
            $linkLength = length($resourceTmp);
            $Link = substr($resourceTmp,$Pos,$linkLength);
            $resourceContent .= "<li>$newWindow$Link\<\/li>\n";
          } else
          {
            $resourceContent .= "<li>$resourceTmp\<\/li>\n";
          }
        }
      } # End of resource content
    } # End of content loop
    $slideContent = "$resourceContent\n";
#
# Create video web page
    @contentTable = split("\n", $slideContent);
    $ttl = $#contentTable+1;
    $slideContent = '';
    for ($k=0;$k<$ttl;$k++)
    {
      $slideText = $contentTable[$k];
      $vidFile = lc($slideText);
      $vidFile =~ s/ +/ /g;  # concatenate several white spaces to only one
      $vidFile =~ s/^ //;  # Remove all the starting white spaces in the content
      $vidFile =~ s/ $//;  # Remove all trailing white spaces in the content
      $vidLength = length($vidFile);
      $vidStart = '';
      $Pos = index($vidFile, "playvideo: ");
      if ($Pos > 0)
      {
        $vidStart = substr($vidFile,0,$Pos);
        $vidFile =~ s/$vidStart//;  # Remove pre-video name characters
        $vidLength = length($vidFile);
        $Pos = index($vidFile, "playvideo: ");
      }
      if ($Pos == 0)
      {
        $vidFile =~ s/playvideo: //;    # remove item tag
        $Pos = index($vidFile, ".mp4");
        if ($Pos > 0)
        {
          $vidName = substr($vidFile,0,$Pos);
          $vidEnd = '';
          if ($vidLength > $Pos+3) { $vidEnd = substr($vidFile,$Pos+4,$vidLength); }
          $vidPage = "video$_[2]-$vidName$ext";
          $vidLink = "$newWindow$vidPage\">$vidName (MP4)</a>";
          open(SUBPAGE, ">$vidPage");
          print SUBPAGE <<END;
$doctype
<html$langattr>
<head>
<meta http-equiv="Content-type" content="text/html" charset="$charset">
<meta name="viewport" content="width=device-width, initial-scale=1.0" >
<title>$vidName | $talkTitle</title>
$styleLink
</head>
<body>
<video class="alignCenter" width="75%" height="75%" controls><source src="$talkAV/$vidName\.mp4" type="video/mp4">Your browser does not support the video element.</video>
</body>
</html>
END
        close(SUBPAGE);
        $slideText = "$vidStart$vidLink$vidEnd\n";
        }
      }
      $slideContent .= "$slideText\n";
    }
#
# Generate all the Tab lists for the current slide
    $contentLength = length($slideContent);
    @contentTable = split("\n", $slideContent);
    $ttl = $#contentTable+1;
    $slideContent = '';
    $found = 0;
    $tabCount = 0;
    $tag = "$startTab";
    $slideText = '';
    for ($k=0;$k<$ttl;$k++)
    {
      $tabTmp = $contentTable[$k];
      $tagPos = index($tabTmp, "<$tag");
      if ($found == 0)
      {  
        if ($tagPos>-1)
        {
          $found = 1;
          $tag = "$endTab";
          $tabCount++;
          $tabNbr = 0;
          $tabList = '';
          $tabPanel = '';
          $slideText = '';
        } else
        {
          $slideContent .= "$tabTmp\n";
        }
      } else
      {
        if ($tagPos>-1)
        {
          $found = 0;
          $tabNbr = 0;
          $tag = "$startTab";
          $tabPanel .= "<\/div>\n";
          $slideText = "<div role=tablist aria-labelledby=tablist-$tabCount class=automatic>\n";
          $slideText .= "<div class=tabs>\n";
          $slideText .= "$tabList\n";
          $slideText .= "<\/div>\n";
          $slideText .= "$tabPanel\n";
          $tabList = '';
          $tabPanel = '';
          $slideContent .= "$slideText\n";
          $slideText = '';
        } else
        {
          $Pos = index($tabTmp, "<$startList>");
          if ($Pos>-1)
          {
            $tabTmp =~ s/<$startList>//;    # remove item tag
            $tabNbr++;
            $tabName = "Tab$tabNbr";
            $tabLength = length($tabTmp);
            $Pos = index($tabTmp, ": ");
            if ($Pos>0) { $tabName = substr($tabTmp,0,$Pos); };
            $tabContent = substr($tabTmp,$Pos+2,$tabLength);
            $Pos = index($tabContent, "<$endList>");
            $tabContent =~ s/<$endList>//;    # remove item tag
            $tabList .= "<button id=tab-$tabCount-$tabNbr type=button role=tab aria-selected=false aria-controls=tabpanel-$tabCount-$tabNbr tabindex=-1>\n";
            $tabList .= "<span class=focus>$tabName<\/span>\n";
            $tabList .= "<\/button>\n";
            $tabPanel .= "<div id=tabpanel-$tabCount-$tabNbr role=tabpanel tabindex=0 aria-labelledby=tab-$tabCount-$tabNbr class=is-hidden>\n";
            $tabPanel .= "<div role=alert aria-live=polite>$tabContent\n";
            if ($Pos>-1) { $tabPanel .= "<\/div><\/div>\n"; }
          } else
          {
            $Pos = index($tabTmp, "<$endList>");
            $tabTmp =~ s/<$endList>//;    # remove item tag
            $tabPanel .= "$tabTmp\n";
            if ($Pos>-1) { $tabPanel .= "<\/div><\/div>\n"; }
          }
        }
      }
    }
#
# Generate all the subpages for the current slide
    $contentLength = length($slideContent);
    @contentTable = split("\n", $slideContent);
    $ttl = $#contentTable+1;
    $found = 0;
    $pageCount = 0;
    $tag = "$startPage";
    $slideContent = '';
    $slideText = '';
    $pageContent = '';
    @pageTable = ();
    for ($k=0;$k<$ttl;$k++)
    {
      $pageTmp = $contentTable[$k];
      $tagPos = index($pageTmp, "<$tag");
      if ($found == 0)
      {  
        if ($tagPos>-1)
        {
          $found = 1;
          $tag = "$endPage";
          $txtTmp = $contentTable[$k+1];
          $pageName = "slide$_[2]-$i-$pageCount$ext\#main";
          $pageLink = "<a href=\"$pageName\">$txtTmp</a>";
          $slideText .= "$pageLink\n";
        } else
        {
          $slideText .= "$pageTmp\n";
        }
        $slideContent .= "$slideText\n";
        $slideText = '';
      } else
      {
        if ($tagPos>-1)
        {
          $found = 0;
          $tag = "$startPage";
          $pageTable[$pageCount] = $pageContent;
          $pageContent = '';
          $pageCount++;
        } else
        {
          $pageContent .= "$pageTmp\n";
        }
      }
    }
#
# Remove all blank lines from slide content
    $contentLength = length($slideContent);
    @contentTable = split("\n", $slideContent);
    $ttl = $#contentTable+1;
    $slideContent = '';
    for ($k=0;$k<$ttl;$k++)
    {
      $slideText = $contentTable[$k];
      $slideText =~ s/ +/ /g;     # concatenate several white spaces to only one
      $slideText =~ s/^ //;       # Remove all the starting white spaces in the content
      $slideText =~ s/ $//;       # Remove all trailing white spaces in the content
      if (length $slideText != 0)
      {
        $slideContent .= "$slideText\n";
      }
    }
#
# Remove all blank lines from subpages
    $pageContent = '';
    $ttl = $#pageTable+1;
    for ($k=0;$k<$ttl;$k++)
    {
      $pageTmp = $pageTable[$k];
      $pageTmp =~ s/ +/ /g;     # concatenate several white spaces to only one
      $pageTmp =~ s/^ //;       # Remove all the starting white spaces in the content
      $pageTmp =~ s/ $//;       # Remove all trailing white spaces in the content
      if (length $pageTmp != 0)
      {
        $pageContent .= "$pageTmp\n";
      }
    }
#
# Output slide subpage content
    $ttl = $#pageTable+1;
    for ($k=0;$k<$ttl;$k++)
    {
      $pageName = "slide$_[2]-$i-$k";
      $pageContent = $pageTable[$k];
      open(SUBPAGE, ">$pageName$ext");
      print SUBPAGE <<END;
$doctype
<html$langattr>
<head>
<meta http-equiv="Content-type" content="text/html" charset="$charset">
<meta name="viewport" content="width=device-width, initial-scale=1.0" >
<title>$pageName | $slideTitle | $talkTitle</title>
$styleLink
<script type="text/javascript" src="$talkjs/jquery-1.11.0.min.js"></script>
<script type="text/javascript" src="$talkjs/detailsGroup.js"></script>
<script type="text/javascript" src="$talkjs/AutoTab.js"></script>
<script type="text/javascript" src="$talkjs/CommentToggle.js"></script>
<script type="text/javascript" src="$talkjs/utils.js"></script>
</head>
<body>
<main class="maincontent">
<h1 id="main" class="alignCenter">$slideTitle</h1>
$pageContent
<!-- <p><a class=CloseBtn href="$slideName"><button>Back to previous slide</button></a></p> -->
<p><button accesskey="b" class=CloseBtn onClick="history.go(-1);return true;">Back to previous page</button><br>
<hr class="bottom"></p>
</main>
</body>
</html>
END
      close(SUBPAGE);
    }
#
# Output the main slide content
    open(SLIDE, ">$slideName");
    print SLIDE <<END;
$doctype
<html$langattr>
<head>
<meta http-equiv="Content-type" content="text/html" charset="$charset">
<meta name="viewport" content="width=device-width, initial-scale=1.0" >
<title>Slide$_[2]-$total | $talkTitle</title>
$firstlink
$lastlink
$nextlink
$prevlink
$toclink
$styleLink
<script type="text/javascript" src="$talkjs/jquery-1.11.0.min.js"></script>
<script type="text/javascript" src="$talkjs/detailsGroup.js"></script>
<script type="text/javascript" src="$talkjs/AutoTab.js"></script>
<script type="text/javascript" src="$talkjs/CommentToggle.js"></script>
<script type="text/javascript" src="$talkjs/utils.js"></script>
</head>
<body>
<main class="maincontent">
<h1 id="main" class="alignCenter">Slide$_[2]-$total $_[0]</h1>
$slideContent
$trailer
</main>
<footer role=region class="footercontent" aria-label="Control Panel">
$navFoot
</footer>
</body>
</html>
END
    close(SLIDE);
  }
  return 0;
}
#
# End of creating slide
##############################################################################

##############################################################################
# Generate all the toc of contents needed for each css choosen by the user.
# The default toc is not numbered so it can be served by a request to '/'. (ie it remains Overview$ext whereas the other toc are called Overview_#$ext)
#
sub generateTOC
{
# Read the general toc
#print STDOUT "\n--- Generate TOC subroutine ---\n";
  open(LST, "<$overview$ext");
  @TOC = <LST>;
  close(LST);
  $toc = "@TOC";
  local($lastslide);
  $lastslide = $nbCSSlist - 1;
# For each user CSS file starting after the default css
  for ($css=1;$css<$nbCSSlist;$css++)
  {
# Create new TOC
    $newTOC = $toc;
# Replace the navigation link elements
    $newTOC =~ s#<link rel=\"next\" href=\"[^\"]*\" title=\"Next\">#<link rel=\"next\" href=\"slide1-$css.html\" title=\"Next\">#ig;
    $newTOC =~ s#<link rel=\"first\" href=\"[^\"]*\" title=\"First\">#<link rel=\"first\" href=\"slide1-$css.html\" title=\"First\">#ig;
    $newTOC =~ s#<link rel=\"last\" href=\"[^\"]*\" title=\"Last\">#<link rel=\"last\" href=\"slide$lastslide-$css.html\" title=\"Last\">#ig;
# Replace the style link with a new one	
# We eventually choose the user css file if any
    $newTOC =~ s#<link href=\"[^\"]*\" rel=\"stylesheet\" type=\"text\/css\" title=\"Talk\">#<link href=\"$talkCSS\/$CSSlist[$css]\" rel=\"stylesheet\" type=\"text\/css\" title=\"Talk\">#ig;
    if ($CSSuser[$css])
    {
      $newTOC =~ s#<link href=\"[^\"]*\" rel=\"stylesheet\" type=\"text\/css\" title=\"User Talk\">#<link href=\"$talkCSS\/$CSSuser[$css]\" rel=\"stylesheet\" type=\"text\/css\" title=\"User Talk\">#ig;
    }
# The links on the toc need also to be modified to link to the correct slides
    $newTOC =~ s/<a accesskey=\"(\d)\" tabindex=\"(\d+)\" href=\"slide(\d+)-\d+$ext#main\">/<a accesskey=\"$1\" tabindex=\"$2\" href=\"slide$3-$css$ext">/ig;
    $newTOC =~ s/<a tabindex=\"(\d+)\" href=\"slide(\d+)-\d+$ext#main\">/<a tabindex=\"$1\" href=\"slide$2-$css$ext">/ig;
    $outfile = "$overview$css$ext";
    open(OUT,">$outfile");
    print OUT $newTOC;
    close(OUT);
  }
}
# End of TOC generation
####################################################################

##############################################################################
# Check that the HTML of the slide is correct (alt attributes, ...). This procedure produces only warning
#
sub verify_html
{
#print STDOUT "\n--- Verify_html subroutine ---\n";
  if ($_[0] =~ /<img([^>]*)>/im)
  {
    if (!($1 =~ /alt=/im))
    {
      print STDOUT "WARNING: <img> without alt\n";
    }
  }
}
#
# End of verify HTML
##############################################################################

##############################################################################
# Clean the html of the slide
# Remove all <div class="comment"> ... </div>
#
sub clean_html
{
#print STDOUT "\n--- clean_html subroutine ---\n";
  $_[0] =~ s/<div\s+class\s*=\s*(?:comment[\s>]|\"comment\").*?<\/div>//igs;
  return $_[0];
}
#
# End of clean HTML
##############################################################################
