#!/usr/bin/perl
# LogUpdate.pl update user log (created by UserTable.html) called from Trailer.html
# See Config.ini for instructions
# Author: David best
# Website: https://www.bestaccessibility.consulting
##############################################################################

use warnings;
use File::Find;
use File::Path;
use Mail::Sendmail;
use CGI;
$query = new CGI;
use Cwd;
chdir('..');
print "Content-type: text/html\n\n";
#print Dump;

# Starting user learning feedback process
&DefaultParameters;
&DefaultConfig;
&UpdateUserLog;
#&SendEmail;
#
# Return to the topic selection page
print STDOUT <<END;
$doctype
<html$langattr>
<head>
<meta http-equiv='refresh' content='30;URL=$homeDir/$talkDir/TalkSelect.html'>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Talk Learning Feedback</title>
<link href="$styleLink" rel="stylesheet" type="text/css\" title=\"Talk">
</head>
<body>
<main class="maincontent">
<h1 id="main" class="alignCenter">Learning Feedback Complete</h1>
<p>Your learning feedback has been recorded.</p>
<p>Redirecting to the user Talk Select learning topic page in 30 seconds.<br>
<a href="$homeDir/$talkDir/TalkSelect.html">Close</a></p>
</main>
</body>
</html>
END
exit;
#
# End of user learning feedback process
##############################################################################

##############################################################################
# Set default parameters
sub DefaultParameters
{
  my ($day, $month, $year) = (localtime(time))[3,4,5];
  my ($second, $minute, $hour) = (localtime(time))[0,1,2];
  if ( $hour < 10 ) { $hour = "0$hour"; }
  if ( $minute < 10 ) { $minute = "0$minute"; }
  if ( $second < 10 ) { $second = "0$second"; }
  if ( $day < 10 ) { $day = "0$day"; }
  $month++;
  if ( $month < 10 ) { $month = "0$month"; }
  $year += 1900;
  $cdate        = "$year-$month-$day";
  $ctime        = "$hour:$minute:$second";

  $modeCode = '';
  $modeCode = $query->param('ModeCode');
  $talkTopic = $query->param('TalkTopic');
  $userName = $query->param('UserName');
  $userEmail = $query->param('Email');
  $Comment = $query->param('Comment');
  $Message = $query->param('Message');

  $homeDir = 'https://edu.davidbest.ca';
  $talkDir = 'Talk';
  $talkAV = "$homeDir\/$talkDir\/AV";
  $talkdoc = "$homeDir\/$talkDir\/doc";
  $talkimg = "$homeDir\/$talkDir\/img";
  $talkjs = "$homeDir\/$talkDir\/js";
  $talkCSS = "$homeDir\/$talkDir\/CSS";
  $CSSfiles = 'style1.css,style2.css';
  $CSSUserFiles = 'style1.css,style2.css';
  $styleLink = "$talkCSS\/style1.css";
  $Config = 'Config.ini';
  $userLog = 'UserLog.html';
  $tmpfile = 'tmp.html';
}
# End of default parameters
##############################################################################

##############################################################################
# Reading Talk parameters input from config.ini
sub DefaultConfig
{
#print STDOUT "\n--- Reading config file $Config ---\n";
  if (open(CFG, $Config))
  {
    local(@file,$counter);
    $counter = 0;
    @file = <CFG>;
    @PARAM = ();
    do
    { if ($file[0] =~ /^[^#\n\r]/)
      {
        $file[0] =~ s/\n//;    # remove UNIX \n 
        $file[0] =~ s/\r//;    # remove WINDOWS \r    
        $file[0] =~ s/ *= */=/;
        $PARAM[$counter++] = $file[0];
      }
    } while (shift(@file));
#
# process parameters
# Each preset variable is now re-attributed using the user preferences
    foreach (@PARAM)
    {
      @_ = split(/ *= */);
      $cmd="\$$_[0] = \'$_[1]\';";
      if (length $_[1] != 0)
      {
        eval($cmd);
      }
    }
#
# save the style sheet file locations into tables 
    @CSSlist = split(',',$CSSfiles);
    $nbCSSlist = $#CSSlist + 1;
    @CSSuser = split(',',$CSSUserFiles);
    $nbCSSuser = $#CSSuser + 1;
    $styleLink = "$talkCSS\/$CSSlist[0]";
  }
}
# End of reading $config file parameters
##############################################################################

##############################################################################
# Update User Log table
sub UpdateUserLog
{
#print STDOUT "\n--- Reading user log $userLog ---\n";
  my $sep = $/;
  $/ = undef;
  if (length $userEmail < 8) { return; }
  if (open(USR, "<$userLog"))
  { $log = <USR>; } else { exit; }
  $result = close(USR);
  $tag = "</tr>";
  @table = split(/$tag/i, $log);
  $RowTotal = $#table + 1;  # compute the total number of rows
  $RowTotal++;
  $log .= "<tr><td>$RowTotal<\/td><td>$cdate\/$ctime<\/td><td>$userName<\/td><td>$userEmail<\/td><td>$talkTopic<\/td><td>$Comment<\/td><td>$Message<\/td><\/tr>";
  open(USR, ">$userLog");
  print USR $log;
  $result = close(USR);
  $/ = $sep;
}
# the User Log has been updated and saved
##############################################################################

##############################################################################
# Send email notice to author (currently not used)
sub SendEmail
{
  my $to   = $AuthorEmail;
  my $from = 'info@davidbest.ca';
  my $subj = "User Feedback For $Subject";
  my $msg  = "$subj\n\n";
  my $msg .= "User: $UserName - $UserEmail\n\n";
  my $msg .= "Comment: $comment\n\n";
  my $msg .= "Message: $message\n\n";
  my $msg .= "End of feedback.\n\n";
  open (MAIL, "|/usr/sbin/Sendmail -t");
  print MAIL 'MIME-Version: 1.0';
  print MAIL 'Content-Type: text/html; charset="us-ascii"';
  print MAIL 'Content-Transfer-Encoding: 7bit';
  print MAIL "To: $to\n";
  print MAIL "From: $from\n";
  print MAIL "Subject: $subj\n\n";
  print MAIL "$msg\n\n";
  $result = close(MAIL);
  if ($result)
  {
#   print "Email Sent. Result = $result\n";
  } else
  {
    print "There was a problem sending email. Result=$result er1=$! er2=$? \n";
    exit 0;
  }
}
# The user information has been sent to the author
##############################################################################
